"use client";

import { AlertTriangle, Trash, X } from "lucide-react";
import { useEffect, useState } from "react";
import { createPortal } from "react-dom";

interface DeleteModalProps {
  isOpen: boolean;
  onClose: () => void;
  onConfirm: () => void;
  title?: string;
  description?: string;
  itemName?: string;
}

export default function DeleteModal({ 
  isOpen, 
  onClose, 
  onConfirm, 
  title = "Delete Item", 
  description = "Are you sure you want to delete this item? This action cannot be undone.",
  itemName
}: DeleteModalProps) {
  const [mounted, setMounted] = useState(false);

  useEffect(() => {
    setMounted(true);
    if (isOpen) {
      document.body.style.overflow = 'hidden';
    } else {
      document.body.style.overflow = 'unset';
    }
    return () => {
        document.body.style.overflow = 'unset';
    };
  }, [isOpen]);

  if (!mounted || !isOpen) return null;

  return createPortal(
    <div className="position-fixed top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center" style={{ zIndex: 1050 }}>
      {/* Backdrop */}
      <div 
        className="position-absolute top-0 start-0 w-100 h-100" 
        style={{ backgroundColor: 'rgba(0,0,0,0.5)', backdropFilter: 'blur(2px)' }}
        onClick={onClose}
      />

      {/* Modal */}
      <div className="card-custom border-0 shadow-lg p-0 animate-scale-in position-relative" style={{ width: '100%', maxWidth: '400px' }}>
        <div className="p-4 text-center">
          <div className="mb-4 d-inline-flex p-3 rounded-circle bg-danger bg-opacity-10 text-danger">
            <AlertTriangle size={32} />
          </div>
          
          <h5 className="fw-bold mb-2" style={{ color: 'var(--text-color)' }}>{title}</h5>
          
          <p className="text-muted-custom small mb-1">{description}</p>
          {itemName && <p className="fw-bold fw-italic" style={{ color: 'var(--text-color)' }}>"{itemName}"</p>}
          
          <div className="d-flex gap-3 justify-content-center mt-4">
            <button 
              onClick={onClose}
              className="btn d-flex align-items-center gap-2 fw-semibold px-4"
              style={{ color: 'var(--muted-text)', borderColor: 'var(--border-color)' }}
            >
              Cancel
            </button>
            <button 
              onClick={onConfirm}
              className="btn btn-danger d-flex align-items-center gap-2 px-4 fw-bold shadow-sm"
            >
              <Trash size={16} />
              Delete
            </button>
          </div>
        </div>
      </div>
    </div>,
    document.body
  );
}
