"use client";

import PageHeader from "@/components/admin/PageHeader";
import { 
  BarChart as BarChartIcon, 
  TrendingUp, 
  Users, 
  ShoppingBag, 
  DollarSign 
} from "lucide-react";
import { 
  AreaChart, 
  Area, 
  XAxis, 
  YAxis, 
  CartesianGrid, 
  Tooltip, 
  ResponsiveContainer,
  BarChart,
  Bar,
  PieChart,
  Pie,
  Cell,
  Legend
} from 'recharts';

const REVENUE_DATA = [
  { name: 'Jan', value: 4000 },
  { name: 'Feb', value: 3000 },
  { name: 'Mar', value: 2000 },
  { name: 'Apr', value: 2780 },
  { name: 'May', value: 1890 },
  { name: 'Jun', value: 2390 },
  { name: 'Jul', value: 3490 },
  { name: 'Aug', value: 4200 },
  { name: 'Sep', value: 5100 },
  { name: 'Oct', value: 4800 },
  { name: 'Nov', value: 5600 },
  { name: 'Dec', value: 6200 },
];

const ORDER_STATUS_DATA = [
  { name: 'Completed', value: 65, color: '#10b981' },
  { name: 'Cancelled', value: 10, color: '#ef4444' },
  { name: 'Pending', value: 25, color: '#f59e0b' },
];

const USER_GROWTH_DATA = [
  { name: 'Mon', users: 120 },
  { name: 'Tue', users: 150 },
  { name: 'Wed', users: 180 },
  { name: 'Thu', users: 220 },
  { name: 'Fri', users: 300 },
  { name: 'Sat', users: 350 },
  { name: 'Sun', users: 380 },
];

export default function AdminAnalyticsPage() {
  return (
    <div className="py-2">
      <PageHeader 
        title="Analytics Dashboard" 
        description="Comprehensive insights into platform performance."
      />

      {/* KPI Cards */}
      <div className="row g-4 mb-4">
        <div className="col-12 col-md-3">
          <div className="card-custom p-4 h-100">
            <div className="d-flex justify-content-between align-items-start mb-2">
              <div>
                <p className="small text-muted-custom fw-bold text-uppercase mb-1">Total Sales</p>
                <h3 className="fw-bold mb-0 text-color-custom">$125,430</h3>
              </div>
              <div className="rounded-3 p-2 bg-success bg-opacity-10 text-success">
                <DollarSign size={20} />
              </div>
            </div>
            <p className="small text-success fw-bold mb-0">
              <TrendingUp size={14} className="me-1 d-inline-block" />
              +12.5% from last month
            </p>
          </div>
        </div>
        <div className="col-12 col-md-3">
          <div className="card-custom p-4 h-100">
            <div className="d-flex justify-content-between align-items-start mb-2">
              <div>
                <p className="small text-muted-custom fw-bold text-uppercase mb-1">Total Orders</p>
                <h3 className="fw-bold mb-0 text-color-custom">8,520</h3>
              </div>
              <div className="rounded-3 p-2 bg-primary bg-opacity-10 text-primary">
                <ShoppingBag size={20} />
              </div>
            </div>
            <p className="small text-success fw-bold mb-0">
              <TrendingUp size={14} className="me-1 d-inline-block" />
              +8.2% from last month
            </p>
          </div>
        </div>
        <div className="col-12 col-md-3">
          <div className="card-custom p-4 h-100">
            <div className="d-flex justify-content-between align-items-start mb-2">
              <div>
                <p className="small text-muted-custom fw-bold text-uppercase mb-1">Active Users</p>
                <h3 className="fw-bold mb-0 text-color-custom">24.5k</h3>
              </div>
              <div className="rounded-3 p-2 bg-info bg-opacity-10 text-info">
                <Users size={20} />
              </div>
            </div>
            <p className="small text-success fw-bold mb-0">
              <TrendingUp size={14} className="me-1 d-inline-block" />
              +15.3% from last month
            </p>
          </div>
        </div>
        <div className="col-12 col-md-3">
          <div className="card-custom p-4 h-100">
            <div className="d-flex justify-content-between align-items-start mb-2">
              <div>
                <p className="small text-muted-custom fw-bold text-uppercase mb-1">Avg. Order Value</p>
                <h3 className="fw-bold mb-0 text-color-custom">$42.50</h3>
              </div>
              <div className="rounded-3 p-2 bg-warning bg-opacity-10 text-warning">
                <BarChartIcon size={20} />
              </div>
            </div>
            <p className="small text-danger fw-bold mb-0">
              <TrendingUp size={14} className="me-1 d-inline-block rotate-180" />
              -2.1% from last month
            </p>
          </div>
        </div>
      </div>

      <div className="row g-4 mb-4">
        {/* Revenue Chart */}
        <div className="col-12 col-lg-8">
          <div className="card-custom p-4 h-100">
            <h5 className="fw-bold mb-4 text-color-custom">Revenue Overview</h5>
            <div style={{ width: '100%', height: 350 }}>
              <ResponsiveContainer>
                <AreaChart data={REVENUE_DATA}>
                  <defs>
                    <linearGradient id="colorRevenue" x1="0" y1="0" x2="0" y2="1">
                      <stop offset="5%" stopColor="var(--primary)" stopOpacity={0.3}/>
                      <stop offset="95%" stopColor="var(--primary)" stopOpacity={0}/>
                    </linearGradient>
                  </defs>
                  <CartesianGrid strokeDasharray="3 3" vertical={false} stroke="var(--border-color)" />
                  <XAxis 
                    dataKey="name" 
                    axisLine={false} 
                    tickLine={false} 
                    tick={{ fill: 'var(--muted-text)', fontSize: 12 }} 
                    dy={10}
                  />
                  <YAxis 
                    axisLine={false} 
                    tickLine={false} 
                    tick={{ fill: 'var(--muted-text)', fontSize: 12 }} 
                    tickFormatter={(value) => `$${value}`}
                  />
                  <Tooltip 
                    contentStyle={{ 
                      backgroundColor: 'var(--card-bg)', 
                      borderColor: 'var(--border-color)', 
                      borderRadius: '8px', 
                      color: 'var(--text-color)' 
                    }}
                    itemStyle={{ color: 'var(--text-color)' }}
                  />
                  <Area 
                    type="monotone" 
                    dataKey="value" 
                    stroke="var(--primary)" 
                    strokeWidth={3}
                    fillOpacity={1} 
                    fill="url(#colorRevenue)" 
                  />
                </AreaChart>
              </ResponsiveContainer>
            </div>
          </div>
        </div>

        {/* Order Status Chart */}
        <div className="col-12 col-lg-4">
          <div className="card-custom p-4 h-100">
            <h5 className="fw-bold mb-4 text-color-custom">Order Status</h5>
            <div style={{ width: '100%', height: 350 }}>
              <ResponsiveContainer>
                <PieChart>
                  <Pie
                    data={ORDER_STATUS_DATA}
                    cx="50%"
                    cy="50%"
                    innerRadius={80}
                    outerRadius={120}
                    paddingAngle={5}
                    dataKey="value"
                  >
                    {ORDER_STATUS_DATA.map((entry, index) => (
                      <Cell key={`cell-${index}`} fill={entry.color} strokeWidth={0} />
                    ))}
                  </Pie>
                  <Tooltip 
                     contentStyle={{ 
                      backgroundColor: 'var(--card-bg)', 
                      borderColor: 'var(--border-color)', 
                      borderRadius: '8px', 
                      color: 'var(--text-color)' 
                    }}
                    itemStyle={{ color: 'var(--text-color)' }}
                  />
                  <Legend verticalAlign="bottom" height={36} iconType="circle" />
                </PieChart>
              </ResponsiveContainer>
            </div>
          </div>
        </div>
      </div>

       <div className="row g-4">
         {/* User Growth */}
         <div className="col-12">
            <div className="card-custom p-4">
               <h5 className="fw-bold mb-4 text-color-custom">Weekly User Growth</h5>
               <div style={{ width: '100%', height: 300 }}>
                <ResponsiveContainer>
                  <BarChart data={USER_GROWTH_DATA}>
                    <CartesianGrid strokeDasharray="3 3" vertical={false} stroke="var(--border-color)" />
                    <XAxis 
                      dataKey="name" 
                      axisLine={false} 
                      tickLine={false} 
                      tick={{ fill: 'var(--muted-text)', fontSize: 12 }} 
                      dy={10}
                    />
                    <YAxis 
                      axisLine={false} 
                      tickLine={false} 
                      tick={{ fill: 'var(--muted-text)', fontSize: 12 }} 
                    />
                    <Tooltip 
                      cursor={{ fill: 'var(--hover-bg)' }}
                      contentStyle={{ 
                        backgroundColor: 'var(--card-bg)', 
                        borderColor: 'var(--border-color)', 
                        borderRadius: '8px', 
                        color: 'var(--text-color)' 
                      }}
                      itemStyle={{ color: 'var(--text-color)' }}
                    />
                    <Bar dataKey="users" fill="var(--accent)" radius={[8, 8, 0, 0]} barSize={50} />
                  </BarChart>
                </ResponsiveContainer>
              </div>
            </div>
         </div>
       </div>
    </div>
  );
}
