(globalThis.TURBOPACK || (globalThis.TURBOPACK = [])).push([typeof document === "object" ? document.currentScript : undefined,
"[project]/frontend/src/services/api.ts [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "AppointmentService",
    ()=>AppointmentService,
    "AuthService",
    ()=>AuthService,
    "BannerService",
    ()=>BannerService,
    "CategoryService",
    ()=>CategoryService,
    "CouponService",
    ()=>CouponService,
    "DriverService",
    ()=>DriverService,
    "LocationChargeService",
    ()=>LocationChargeService,
    "OrderService",
    ()=>OrderService,
    "ProductService",
    ()=>ProductService,
    "ProviderService",
    ()=>ProviderService,
    "RideService",
    ()=>RideService,
    "StoreService",
    ()=>StoreService,
    "UserService",
    ()=>UserService,
    "VehicleTypeService",
    ()=>VehicleTypeService,
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$build$2f$polyfills$2f$process$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = /*#__PURE__*/ __turbopack_context__.i("[project]/frontend/node_modules/next/dist/build/polyfills/process.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$axios$2f$lib$2f$axios$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/node_modules/axios/lib/axios.js [app-client] (ecmascript)");
;
const API_URL = ("TURBOPACK compile-time value", "https://admin.captaincity.net/api") || 'https://admin.captaincity.net/api';
const api = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$axios$2f$lib$2f$axios$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"].create({
    baseURL: API_URL,
    headers: {
        'Accept': 'application/json'
    }
});
// Add interceptor to include auth token
api.interceptors.request.use((config)=>{
    const token = localStorage.getItem('token'); // Assuming token is stored in localStorage
    if (token) {
        config.headers.Authorization = `Bearer ${token}`;
    }
    return config;
});
const AuthService = {
    login: (credentials)=>api.post('/login', credentials),
    logout: ()=>api.post('/logout'),
    user: ()=>api.get('/user')
};
const UserService = {
    getAll: (params)=>api.get('/admin/users', {
            params
        }),
    getOne: (id)=>api.get(`/admin/users/${id}`),
    create: (data)=>api.post('/admin/users', data),
    update: (id, data)=>{
        if (data instanceof FormData) {
            if (!data.has('_method')) {
                data.append('_method', 'PUT');
            }
            return api.post(`/admin/users/${id}`, data);
        }
        return api.put(`/admin/users/${id}`, data);
    },
    delete: (id)=>api.delete(`/admin/users/${id}`)
};
const StoreService = {
    getAll: (params)=>api.get('/admin/vendors', {
            params
        }),
    getOne: (id)=>api.get(`/admin/vendors/${id}`),
    create: (data)=>api.post('/admin/vendors', data),
    update: (id, data)=>api.put(`/admin/vendors/${id}`, data),
    delete: (id)=>api.delete(`/admin/vendors/${id}`)
};
const ProductService = {
    getAll: (params)=>api.get("/admin/products", {
            params
        }),
    getOne: (id)=>api.get(`/admin/products/${id}`),
    create: (data)=>api.post("/admin/products", data),
    update: (id, data)=>api.put(`/admin/products/${id}`, data),
    delete: (id)=>api.delete(`/admin/products/${id}`)
};
const CategoryService = {
    getAll: (params)=>api.get("/admin/categories", {
            params
        }),
    getOne: (id)=>api.get(`/admin/categories/${id}`),
    create: (data)=>api.post("/admin/categories", data),
    update: (id, data)=>api.put(`/admin/categories/${id}`, data),
    delete: (id)=>api.delete(`/admin/categories/${id}`)
};
const OrderService = {
    getAll: (params)=>api.get("/admin/orders", {
            params
        }),
    getOne: (id)=>api.get(`/admin/orders/${id}`),
    updateStatus: (id, status)=>api.put(`/admin/orders/${id}/status`, {
            status
        }),
    delete: (id)=>api.delete(`/admin/orders/${id}`),
    getActiveLocations: ()=>api.get("/admin/dashboard/active-order-locations")
};
const RideService = {
    getAll: (params)=>api.get("/admin/ride/rides", {
            params
        }),
    getOne: (id)=>api.get(`/admin/ride/rides/${id}`),
    updateStatus: (id, status)=>api.put(`/admin/ride/rides/${id}`, {
            status
        }),
    delete: (id)=>api.delete(`/admin/ride/rides/${id}`)
};
const DriverService = {
    getAll: (params)=>api.get("/admin/ride/drivers", {
            params
        }),
    getOne: (id)=>api.get(`/admin/ride/drivers/${id}`),
    create: (data)=>api.post("/admin/ride/drivers", data),
    update: (id, data)=>api.put(`/admin/ride/drivers/${id}`, data),
    delete: (id)=>api.delete(`/admin/ride/drivers/${id}`)
};
const VehicleTypeService = {
    getAll: (params)=>api.get("/admin/ride/vehicletypes", {
            params
        }),
    getOne: (id)=>api.get(`/admin/ride/vehicletypes/${id}`),
    create: (data)=>api.post("/admin/ride/vehicletypes", data),
    update: (id, data)=>{
        if (!data.has("_method")) {
            data.append("_method", "PUT");
        }
        return api.post(`/admin/ride/vehicletypes/${id}`, data);
    },
    delete: (id)=>api.delete(`/admin/ride/vehicletypes/${id}`)
};
const BannerService = {
    getAll: (params)=>api.get("/admin/banners", {
            params
        }),
    getOne: (id)=>api.get(`/admin/banners/${id}`),
    create: (data)=>api.post("/admin/banners", data),
    update: (id, data)=>{
        if (!data.has("_method")) {
            data.append("_method", "PUT");
        }
        return api.post(`/admin/banners/${id}`, data);
    },
    delete: (id)=>api.delete(`/admin/banners/${id}`)
};
const CouponService = {
    getAll: (params)=>api.get("/admin/coupons", {
            params
        }),
    getOne: (id)=>api.get(`/admin/coupons/${id}`),
    create: (data)=>api.post("/admin/coupons", data),
    update: (id, data)=>api.put(`/admin/coupons/${id}`, data),
    delete: (id)=>api.delete(`/admin/coupons/${id}`)
};
const LocationChargeService = {
    getAll: (params)=>api.get("/admin/ride/location-charges", {
            params
        }),
    getOne: (id)=>api.get(`/admin/ride/location-charges/${id}`),
    create: (data)=>api.post("/admin/ride/location-charges", data),
    update: (id, data)=>api.put(`/admin/ride/location-charges/${id}`, data),
    delete: (id)=>api.delete(`/admin/ride/location-charges/${id}`)
};
const ProviderService = {
    getAll: (params)=>api.get("/admin/providers", {
            params
        }),
    getOne: (id)=>api.get(`/admin/providers/${id}`),
    create: (data)=>api.post("/admin/providers", data),
    update: (id, data)=>api.put(`/admin/providers/${id}`, data),
    delete: (id)=>api.delete(`/admin/providers/${id}`)
};
const AppointmentService = {
    getAll: (params)=>api.get("/admin/provider/appointments", {
            params
        }),
    getOne: (id)=>api.get(`/admin/provider/appointments/${id}`),
    updateStatus: (id, status)=>api.put(`/admin/provider/appointments/${id}`, {
            status
        }),
    delete: (id)=>api.delete(`/admin/provider/appointments/${id}`)
};
const __TURBOPACK__default__export__ = api;
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/frontend/src/app/admin/appointments/[id]/page.tsx [app-client] (ecmascript)", ((__turbopack_context__, module, exports) => {

const e = new Error("Could not parse module '[project]/frontend/src/app/admin/appointments/[id]/page.tsx'\n\nUnexpected token. Did you mean `{'}'}` or `&rbrace;`?");
e.code = 'MODULE_UNPARSABLE';
throw e;
}),
]);

//# sourceMappingURL=frontend_src_5d738de1._.js.map