(globalThis.TURBOPACK || (globalThis.TURBOPACK = [])).push([typeof document === "object" ? document.currentScript : undefined,
"[project]/frontend/src/components/admin/PageHeader.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>PageHeader
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$plus$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Plus$3e$__ = __turbopack_context__.i("[project]/frontend/node_modules/lucide-react/dist/esm/icons/plus.js [app-client] (ecmascript) <export default as Plus>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/node_modules/next/dist/client/app-dir/link.js [app-client] (ecmascript)");
"use client";
;
;
;
function PageHeader({ title, description, actionLabel, actionLink }) {
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        className: "d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-3 mb-4",
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h2", {
                        className: "fw-bold mb-1",
                        style: {
                            color: 'var(--text-color)'
                        },
                        children: title
                    }, void 0, false, {
                        fileName: "[project]/frontend/src/components/admin/PageHeader.tsx",
                        lineNumber: 22,
                        columnNumber: 9
                    }, this),
                    description && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                        className: "lead fs-6 mb-0",
                        style: {
                            color: 'var(--muted-text)'
                        },
                        children: description
                    }, void 0, false, {
                        fileName: "[project]/frontend/src/components/admin/PageHeader.tsx",
                        lineNumber: 24,
                        columnNumber: 11
                    }, this)
                ]
            }, void 0, true, {
                fileName: "[project]/frontend/src/components/admin/PageHeader.tsx",
                lineNumber: 21,
                columnNumber: 7
            }, this),
            actionLabel && actionLink && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                href: actionLink,
                className: "btn btn-primary d-flex align-items-center gap-2 px-4 py-2 rounded-3 fw-bold border-0",
                style: {
                    background: 'linear-gradient(135deg, #f97316 0%, #ea580c 100%)',
                    boxShadow: '0 4px 12px rgba(249, 115, 22, 0.2)'
                },
                children: [
                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$plus$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Plus$3e$__["Plus"], {
                        size: 18
                    }, void 0, false, {
                        fileName: "[project]/frontend/src/components/admin/PageHeader.tsx",
                        lineNumber: 37,
                        columnNumber: 11
                    }, this),
                    actionLabel
                ]
            }, void 0, true, {
                fileName: "[project]/frontend/src/components/admin/PageHeader.tsx",
                lineNumber: 29,
                columnNumber: 9
            }, this)
        ]
    }, void 0, true, {
        fileName: "[project]/frontend/src/components/admin/PageHeader.tsx",
        lineNumber: 20,
        columnNumber: 5
    }, this);
}
_c = PageHeader;
var _c;
__turbopack_context__.k.register(_c, "PageHeader");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/frontend/src/services/api.ts [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "AuthService",
    ()=>AuthService,
    "CategoryService",
    ()=>CategoryService,
    "OrderService",
    ()=>OrderService,
    "ProductService",
    ()=>ProductService,
    "StoreService",
    ()=>StoreService,
    "UserService",
    ()=>UserService,
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$build$2f$polyfills$2f$process$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = /*#__PURE__*/ __turbopack_context__.i("[project]/frontend/node_modules/next/dist/build/polyfills/process.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$axios$2f$lib$2f$axios$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/node_modules/axios/lib/axios.js [app-client] (ecmascript)");
;
const API_URL = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$build$2f$polyfills$2f$process$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"].env.NEXT_PUBLIC_API_URL || 'https://admin.captaincity.net/api';
const api = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$axios$2f$lib$2f$axios$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"].create({
    baseURL: API_URL,
    headers: {
        'Accept': 'application/json'
    }
});
// Add interceptor to include auth token
api.interceptors.request.use((config)=>{
    const token = localStorage.getItem('token'); // Assuming token is stored in localStorage
    if (token) {
        config.headers.Authorization = `Bearer ${token}`;
    }
    return config;
});
const AuthService = {
    login: (credentials)=>api.post('/login', credentials),
    logout: ()=>api.post('/logout'),
    user: ()=>api.get('/user')
};
const UserService = {
    getAll: (params)=>api.get('/admin/users', {
            params
        }),
    getOne: (id)=>api.get(`/admin/users/${id}`),
    create: (data)=>api.post('/admin/users', data),
    update: (id, data)=>{
        if (data instanceof FormData) {
            if (!data.has('_method')) {
                data.append('_method', 'PUT');
            }
            return api.post(`/admin/users/${id}`, data);
        }
        return api.put(`/admin/users/${id}`, data);
    },
    delete: (id)=>api.delete(`/admin/users/${id}`)
};
const StoreService = {
    getAll: (params)=>api.get('/admin/vendors', {
            params
        }),
    getOne: (id)=>api.get(`/admin/vendors/${id}`),
    create: (data)=>api.post('/admin/vendors', data),
    update: (id, data)=>api.put(`/admin/vendors/${id}`, data),
    delete: (id)=>api.delete(`/admin/vendors/${id}`)
};
const ProductService = {
    getAll: (params)=>api.get("/admin/products", {
            params
        }),
    getOne: (id)=>api.get(`/admin/products/${id}`),
    create: (data)=>api.post("/admin/products", data),
    update: (id, data)=>api.put(`/admin/products/${id}`, data),
    delete: (id)=>api.delete(`/admin/products/${id}`)
};
const CategoryService = {
    getAll: ()=>api.get("/admin/categories"),
    getOne: (id)=>api.get(`/admin/categories/${id}`),
    create: (data)=>api.post("/admin/categories", data),
    update: (id, data)=>api.put(`/admin/categories/${id}`, data),
    delete: (id)=>api.delete(`/admin/categories/${id}`)
};
const OrderService = {
    getAll: ()=>api.get("/admin/ecommerce/orders"),
    getOne: (id)=>api.get(`/admin/ecommerce/orders/${id}`),
    updateStatus: (id, status)=>api.put(`/admin/ecommerce/orders/${id}/status`, {
            status
        }),
    delete: (id)=>api.delete(`/admin/ecommerce/orders/${id}`)
};
const __TURBOPACK__default__export__ = api;
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/frontend/src/app/admin/products/[id]/edit/page.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>EditProductPage
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$build$2f$polyfills$2f$process$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = /*#__PURE__*/ __turbopack_context__.i("[project]/frontend/node_modules/next/dist/build/polyfills/process.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$src$2f$components$2f$admin$2f$PageHeader$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/src/components/admin/PageHeader.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$x$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__X$3e$__ = __turbopack_context__.i("[project]/frontend/node_modules/lucide-react/dist/esm/icons/x.js [app-client] (ecmascript) <export default as X>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$upload$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Upload$3e$__ = __turbopack_context__.i("[project]/frontend/node_modules/lucide-react/dist/esm/icons/upload.js [app-client] (ecmascript) <export default as Upload>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$plus$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Plus$3e$__ = __turbopack_context__.i("[project]/frontend/node_modules/lucide-react/dist/esm/icons/plus.js [app-client] (ecmascript) <export default as Plus>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$trash$2d$2$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Trash2$3e$__ = __turbopack_context__.i("[project]/frontend/node_modules/lucide-react/dist/esm/icons/trash-2.js [app-client] (ecmascript) <export default as Trash2>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$file$2d$text$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__FileText$3e$__ = __turbopack_context__.i("[project]/frontend/node_modules/lucide-react/dist/esm/icons/file-text.js [app-client] (ecmascript) <export default as FileText>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$shopping$2d$bag$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ShoppingBag$3e$__ = __turbopack_context__.i("[project]/frontend/node_modules/lucide-react/dist/esm/icons/shopping-bag.js [app-client] (ecmascript) <export default as ShoppingBag>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$layers$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Layers$3e$__ = __turbopack_context__.i("[project]/frontend/node_modules/lucide-react/dist/esm/icons/layers.js [app-client] (ecmascript) <export default as Layers>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$dollar$2d$sign$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__DollarSign$3e$__ = __turbopack_context__.i("[project]/frontend/node_modules/lucide-react/dist/esm/icons/dollar-sign.js [app-client] (ecmascript) <export default as DollarSign>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$archive$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Archive$3e$__ = __turbopack_context__.i("[project]/frontend/node_modules/lucide-react/dist/esm/icons/archive.js [app-client] (ecmascript) <export default as Archive>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$ellipsis$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__MoreHorizontal$3e$__ = __turbopack_context__.i("[project]/frontend/node_modules/lucide-react/dist/esm/icons/ellipsis.js [app-client] (ecmascript) <export default as MoreHorizontal>");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/node_modules/next/dist/client/app-dir/link.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$src$2f$services$2f$api$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/src/services/api.ts [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/node_modules/next/navigation.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$react$2d$hot$2d$toast$2f$dist$2f$index$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/frontend/node_modules/react-hot-toast/dist/index.mjs [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
"use client";
;
;
;
;
;
;
;
function EditProductPage() {
    _s();
    const router = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRouter"])();
    const params = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useParams"])();
    const productId = params.id;
    const [loading, setLoading] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const [fetchingProduct, setFetchingProduct] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(true);
    const [categories, setCategories] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])([]);
    const [vendors, setVendors] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])([]);
    const [imagePreview, setImagePreview] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(null);
    // Form State
    const [formData, setFormData] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])({
        title_en: "",
        title_ar: "",
        detail_en: "",
        detail_ar: "",
        vendor_id: "",
        categories: [],
        price: "",
        stock_quantity: "",
        image: null
    });
    const [addonGroups, setAddonGroups] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])([]);
    const [metaFields, setMetaFields] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])([]);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "EditProductPage.useEffect": ()=>{
            fetchDependencies();
            fetchProduct();
        }
    }["EditProductPage.useEffect"], []);
    const fetchDependencies = async ()=>{
        try {
            const [catRes, vendorRes] = await Promise.all([
                __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$src$2f$services$2f$api$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["CategoryService"].getAll(),
                __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$src$2f$services$2f$api$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["StoreService"].getAll()
            ]);
            setCategories(catRes.data.data || catRes.data || []);
            setVendors(vendorRes.data.data || vendorRes.data || []);
        } catch (err) {
            console.error("Failed to load dependencies", err);
            __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$react$2d$hot$2d$toast$2f$dist$2f$index$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"].error("Failed to load categories or vendors");
        }
    };
    const fetchProduct = async ()=>{
        try {
            setFetchingProduct(true);
            const response = await __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$src$2f$services$2f$api$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ProductService"].getOne(productId);
            const product = response.data.data || response.data;
            // Set basic form data
            setFormData({
                title_en: product.title_translations?.en || product.title || "",
                title_ar: product.title_translations?.ar || "",
                detail_en: product.detail_translations?.en || product.detail || "",
                detail_ar: product.detail_translations?.ar || "",
                vendor_id: product.vendor_products?.[0]?.vendor_id?.toString() || "",
                categories: product.categories?.map((c)=>c.id.toString()) || [],
                price: product.price?.toString() || "",
                stock_quantity: product.vendor_products?.[0]?.stock_quantity?.toString() || "0",
                image: null
            });
            // Set image preview if exists
            if (product.mediaurls?.images?.[0]?.default) {
                setImagePreview(product.mediaurls.images[0].default);
            }
            // Set addon groups
            if (product.addon_groups && product.addon_groups.length > 0) {
                const mappedGroups = product.addon_groups.map((group)=>({
                        title_en: group.title_translations?.en || group.title?.en || "",
                        title_ar: group.title_translations?.ar || group.title?.ar || "",
                        min_choices: group.min_choices?.toString() || "0",
                        max_choices: group.max_choices?.toString() || "1",
                        choices: group.addon_choices?.map((choice)=>({
                                title_en: choice.title_translations?.en || choice.title?.en || "",
                                title_ar: choice.title_translations?.ar || choice.title?.ar || "",
                                price: choice.price?.toString() || "0"
                            })) || []
                    }));
                setAddonGroups(mappedGroups);
            }
            // Set meta fields
            if (product.meta && typeof product.meta === 'object') {
                const metaArray = Object.entries(product.meta).map(([key, value])=>({
                        key,
                        value: value
                    }));
                setMetaFields(metaArray);
            }
        } catch (err) {
            console.error("Failed to load product", err);
            __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$react$2d$hot$2d$toast$2f$dist$2f$index$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"].error("Failed to load product");
            router.push("/admin/products");
        } finally{
            setFetchingProduct(false);
        }
    };
    const handleChange = (e)=>{
        const { name, value } = e.target;
        setFormData((prev)=>({
                ...prev,
                [name]: value
            }));
    };
    const handleCategoryChange = (e)=>{
        const selectedOptions = Array.from(e.target.selectedOptions, (option)=>option.value);
        setFormData((prev)=>({
                ...prev,
                categories: selectedOptions
            }));
    };
    const handleImageChange = (e)=>{
        if (e.target.files && e.target.files[0]) {
            const file = e.target.files[0];
            setFormData((prev)=>({
                    ...prev,
                    image: file
                }));
            setImagePreview(URL.createObjectURL(file));
        }
    };
    // --- Meta Fields Logic ---
    const handleMetaChange = (index, field, value)=>{
        const newMeta = [
            ...metaFields
        ];
        newMeta[index][field] = value;
        setMetaFields(newMeta);
    };
    const addMetaField = ()=>setMetaFields([
            ...metaFields,
            {
                key: "",
                value: ""
            }
        ]);
    const removeMetaField = (index)=>setMetaFields(metaFields.filter((_, i)=>i !== index));
    // --- Addon Group Logic ---
    const addAddonGroup = ()=>{
        setAddonGroups([
            ...addonGroups,
            {
                title_en: "",
                title_ar: "",
                min_choices: "0",
                max_choices: "1",
                choices: []
            }
        ]);
    };
    const removeAddonGroup = (index)=>{
        setAddonGroups(addonGroups.filter((_, i)=>i !== index));
    };
    const updateAddonGroup = (index, field, value)=>{
        const newGroups = [
            ...addonGroups
        ];
        // @ts-ignore
        newGroups[index][field] = value;
        setAddonGroups(newGroups);
    };
    // --- Addon Choice Logic ---
    const addChoice = (groupIndex)=>{
        const newGroups = [
            ...addonGroups
        ];
        newGroups[groupIndex].choices.push({
            title_en: "",
            title_ar: "",
            price: "0"
        });
        setAddonGroups(newGroups);
    };
    const removeChoice = (groupIndex, choiceIndex)=>{
        const newGroups = [
            ...addonGroups
        ];
        newGroups[groupIndex].choices = newGroups[groupIndex].choices.filter((_, i)=>i !== choiceIndex);
        setAddonGroups(newGroups);
    };
    const updateChoice = (groupIndex, choiceIndex, field, value)=>{
        const newGroups = [
            ...addonGroups
        ];
        // @ts-ignore
        newGroups[groupIndex].choices[choiceIndex][field] = value;
        setAddonGroups(newGroups);
    };
    const handleSubmit = async (e)=>{
        e.preventDefault();
        setLoading(true);
        try {
            // Construct Payload
            const productData = {
                price: formData.price,
                stock: formData.stock_quantity,
                vendor_id: formData.vendor_id,
                categories: formData.categories,
                // Translations
                title_translations: [
                    {
                        language: 'en',
                        text: formData.title_en
                    },
                    {
                        language: 'ar',
                        text: formData.title_ar
                    }
                ],
                detail_translations: [
                    {
                        language: 'en',
                        text: formData.detail_en
                    },
                    {
                        language: 'ar',
                        text: formData.detail_ar
                    }
                ],
                // Addons
                addon_groups: addonGroups.map((group)=>({
                        title_translations: [
                            {
                                language: 'en',
                                text: group.title_en
                            },
                            {
                                language: 'ar',
                                text: group.title_ar
                            }
                        ],
                        min_choices: group.min_choices,
                        max_choices: group.max_choices,
                        choices: group.choices.map((choice)=>({
                                title_translations: [
                                    {
                                        language: 'en',
                                        text: choice.title_en
                                    },
                                    {
                                        language: 'ar',
                                        text: choice.title_ar
                                    }
                                ],
                                price: choice.price
                            }))
                    })),
                // Meta
                meta: JSON.stringify(metaFields.reduce((acc, field)=>{
                    if (field.key) acc[field.key] = field.value;
                    return acc;
                }, {}))
            };
            // 1. Update Product
            await __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$src$2f$services$2f$api$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["ProductService"].update(productId, productData);
            // 2. Upload Image if changed
            if (formData.image) {
                const axios = (await __turbopack_context__.A("[project]/frontend/node_modules/axios/index.js [app-client] (ecmascript, async loader)")).default;
                const API_URL = __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$build$2f$polyfills$2f$process$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"].env.NEXT_PUBLIC_API_URL || 'https://admin.captaincity.net/api';
                const token = localStorage.getItem('token');
                const imageData = new FormData();
                imageData.append("image", formData.image);
                imageData.append("_method", "PUT");
                await axios.post(`${API_URL}/admin/products/${productId}`, imageData, {
                    headers: {
                        'Authorization': token ? `Bearer ${token}` : ''
                    }
                });
            }
            __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$react$2d$hot$2d$toast$2f$dist$2f$index$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"].success("Product updated successfully!");
            router.push("/admin/products");
        } catch (err) {
            console.error(err);
            __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$react$2d$hot$2d$toast$2f$dist$2f$index$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"].error(err.response?.data?.message || "Failed to update product");
        } finally{
            setLoading(false);
        }
    };
    if (fetchingProduct) {
        return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
            className: "py-2",
            children: [
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$src$2f$components$2f$admin$2f$PageHeader$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                    title: "Edit Product",
                    description: "Loading product data..."
                }, void 0, false, {
                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                    lineNumber: 285,
                    columnNumber: 9
                }, this),
                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "d-flex justify-content-center align-items-center",
                    style: {
                        minHeight: '400px'
                    },
                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                        className: "spinner-border text-primary",
                        role: "status",
                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                            className: "visually-hidden",
                            children: "Loading..."
                        }, void 0, false, {
                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                            lineNumber: 288,
                            columnNumber: 13
                        }, this)
                    }, void 0, false, {
                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                        lineNumber: 287,
                        columnNumber: 11
                    }, this)
                }, void 0, false, {
                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                    lineNumber: 286,
                    columnNumber: 9
                }, this)
            ]
        }, void 0, true, {
            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
            lineNumber: 284,
            columnNumber: 7
        }, this);
    }
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        className: "py-2",
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$src$2f$components$2f$admin$2f$PageHeader$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                title: "Edit Product",
                description: "Update product information."
            }, void 0, false, {
                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                lineNumber: 297,
                columnNumber: 7
            }, this),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "row justify-content-center",
                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "col-12",
                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("form", {
                        onSubmit: handleSubmit,
                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "row g-4",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "col-12 col-lg-8",
                                    children: [
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "card-custom p-3 mb-3",
                                            children: [
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h5", {
                                                    className: "fw-bold mb-3 d-flex align-items-center gap-2",
                                                    style: {
                                                        color: 'var(--text-color)'
                                                    },
                                                    children: [
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$file$2d$text$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__FileText$3e$__["FileText"], {
                                                            size: 20,
                                                            className: "text-primary-custom"
                                                        }, void 0, false, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 310,
                                                            columnNumber: 21
                                                        }, this),
                                                        "General Information"
                                                    ]
                                                }, void 0, true, {
                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                    lineNumber: 309,
                                                    columnNumber: 19
                                                }, this),
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                    className: "mb-4",
                                                    children: [
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h6", {
                                                            className: "small fw-bold text-muted mb-2 border-bottom pb-1",
                                                            children: "Product Title"
                                                        }, void 0, false, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 316,
                                                            columnNumber: 22
                                                        }, this),
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                            className: "row g-3",
                                                            children: [
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                    className: "col-12 col-md-6",
                                                                    children: [
                                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("label", {
                                                                            className: "form-label small fw-bold text-muted-custom",
                                                                            children: "Title (English)"
                                                                        }, void 0, false, {
                                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                            lineNumber: 319,
                                                                            columnNumber: 25
                                                                        }, this),
                                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("input", {
                                                                            type: "text",
                                                                            name: "title_en",
                                                                            value: formData.title_en,
                                                                            onChange: handleChange,
                                                                            className: "form-control",
                                                                            placeholder: "Product Name",
                                                                            required: true,
                                                                            style: {
                                                                                backgroundColor: 'var(--bg-color)',
                                                                                color: 'var(--text-color)',
                                                                                borderColor: 'var(--border-color)'
                                                                            }
                                                                        }, void 0, false, {
                                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                            lineNumber: 320,
                                                                            columnNumber: 25
                                                                        }, this)
                                                                    ]
                                                                }, void 0, true, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 318,
                                                                    columnNumber: 23
                                                                }, this),
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                    className: "col-12 col-md-6",
                                                                    children: [
                                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("label", {
                                                                            className: "form-label small fw-bold text-muted-custom",
                                                                            children: "Title (Arabic)"
                                                                        }, void 0, false, {
                                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                            lineNumber: 323,
                                                                            columnNumber: 28
                                                                        }, this),
                                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("input", {
                                                                            type: "text",
                                                                            name: "title_ar",
                                                                            value: formData.title_ar,
                                                                            onChange: handleChange,
                                                                            className: "form-control",
                                                                            placeholder: "اسم المنتج",
                                                                            required: true,
                                                                            style: {
                                                                                backgroundColor: 'var(--bg-color)',
                                                                                color: 'var(--text-color)',
                                                                                borderColor: 'var(--border-color)'
                                                                            }
                                                                        }, void 0, false, {
                                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                            lineNumber: 324,
                                                                            columnNumber: 28
                                                                        }, this)
                                                                    ]
                                                                }, void 0, true, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 322,
                                                                    columnNumber: 23
                                                                }, this)
                                                            ]
                                                        }, void 0, true, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 317,
                                                            columnNumber: 22
                                                        }, this)
                                                    ]
                                                }, void 0, true, {
                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                    lineNumber: 315,
                                                    columnNumber: 19
                                                }, this),
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                    children: [
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h6", {
                                                            className: "small fw-bold text-muted mb-2 border-bottom pb-1",
                                                            children: "Description / Details"
                                                        }, void 0, false, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 331,
                                                            columnNumber: 22
                                                        }, this),
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                            className: "row g-3",
                                                            children: [
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                    className: "col-12 col-md-6",
                                                                    children: [
                                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("label", {
                                                                            className: "form-label small fw-bold text-muted-custom",
                                                                            children: "Detail (English)"
                                                                        }, void 0, false, {
                                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                            lineNumber: 334,
                                                                            columnNumber: 26
                                                                        }, this),
                                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("textarea", {
                                                                            name: "detail_en",
                                                                            value: formData.detail_en,
                                                                            onChange: handleChange,
                                                                            className: "form-control",
                                                                            rows: 4,
                                                                            placeholder: "Product Description...",
                                                                            required: true,
                                                                            style: {
                                                                                backgroundColor: 'var(--bg-color)',
                                                                                color: 'var(--text-color)',
                                                                                borderColor: 'var(--border-color)'
                                                                            }
                                                                        }, void 0, false, {
                                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                            lineNumber: 335,
                                                                            columnNumber: 26
                                                                        }, this)
                                                                    ]
                                                                }, void 0, true, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 333,
                                                                    columnNumber: 23
                                                                }, this),
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                    className: "col-12 col-md-6",
                                                                    children: [
                                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("label", {
                                                                            className: "form-label small fw-bold text-muted-custom",
                                                                            children: "Detail (Arabic)"
                                                                        }, void 0, false, {
                                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                            lineNumber: 338,
                                                                            columnNumber: 26
                                                                        }, this),
                                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("textarea", {
                                                                            name: "detail_ar",
                                                                            value: formData.detail_ar,
                                                                            onChange: handleChange,
                                                                            className: "form-control",
                                                                            rows: 4,
                                                                            placeholder: "وصف المنتج...",
                                                                            required: true,
                                                                            style: {
                                                                                backgroundColor: 'var(--bg-color)',
                                                                                color: 'var(--text-color)',
                                                                                borderColor: 'var(--border-color)'
                                                                            }
                                                                        }, void 0, false, {
                                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                            lineNumber: 339,
                                                                            columnNumber: 26
                                                                        }, this)
                                                                    ]
                                                                }, void 0, true, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 337,
                                                                    columnNumber: 23
                                                                }, this)
                                                            ]
                                                        }, void 0, true, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 332,
                                                            columnNumber: 22
                                                        }, this)
                                                    ]
                                                }, void 0, true, {
                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                    lineNumber: 330,
                                                    columnNumber: 19
                                                }, this)
                                            ]
                                        }, void 0, true, {
                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                            lineNumber: 308,
                                            columnNumber: 17
                                        }, this),
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "card-custom p-3 mb-3",
                                            children: [
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                    className: "d-flex justify-content-between align-items-center mb-3",
                                                    children: [
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h5", {
                                                            className: "fw-bold mb-0 d-flex align-items-center gap-2",
                                                            style: {
                                                                color: 'var(--text-color)'
                                                            },
                                                            children: [
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$layers$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Layers$3e$__["Layers"], {
                                                                    size: 20,
                                                                    className: "text-primary-custom"
                                                                }, void 0, false, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 349,
                                                                    columnNumber: 29
                                                                }, this),
                                                                "Addon Groups"
                                                            ]
                                                        }, void 0, true, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 348,
                                                            columnNumber: 25
                                                        }, this),
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                                            type: "button",
                                                            onClick: addAddonGroup,
                                                            className: "btn btn-sm btn-outline-primary fw-bold",
                                                            style: {
                                                                borderColor: 'var(--border-color)',
                                                                color: 'var(--text-color)'
                                                            },
                                                            children: [
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$plus$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Plus$3e$__["Plus"], {
                                                                    size: 16
                                                                }, void 0, false, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 353,
                                                                    columnNumber: 29
                                                                }, this),
                                                                " Add Group"
                                                            ]
                                                        }, void 0, true, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 352,
                                                            columnNumber: 25
                                                        }, this)
                                                    ]
                                                }, void 0, true, {
                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                    lineNumber: 347,
                                                    columnNumber: 21
                                                }, this),
                                                addonGroups.length === 0 && /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                    className: "d-flex flex-column align-items-center justify-content-center py-5 border rounded-3 border-dashed",
                                                    style: {
                                                        borderColor: 'var(--border-color)'
                                                    },
                                                    children: [
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$layers$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Layers$3e$__["Layers"], {
                                                            size: 32,
                                                            className: "text-muted mb-2 opacity-50"
                                                        }, void 0, false, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 359,
                                                            columnNumber: 28
                                                        }, this),
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                                            className: "small text-muted mb-0",
                                                            children: "No addon groups configured."
                                                        }, void 0, false, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 360,
                                                            columnNumber: 28
                                                        }, this),
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                                            type: "button",
                                                            onClick: addAddonGroup,
                                                            className: "btn btn-link btn-sm fw-bold",
                                                            children: "Click to add a group"
                                                        }, void 0, false, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 361,
                                                            columnNumber: 28
                                                        }, this)
                                                    ]
                                                }, void 0, true, {
                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                    lineNumber: 358,
                                                    columnNumber: 25
                                                }, this),
                                                addonGroups.map((group, groupIndex)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                        className: "card-custom p-4 mb-3 border position-relative",
                                                        style: {
                                                            backgroundColor: 'var(--bg-color)'
                                                        },
                                                        children: [
                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                className: "d-flex justify-content-between align-items-center mb-3 pb-2 border-bottom",
                                                                children: [
                                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h6", {
                                                                        className: "fw-bold m-0 text-primary-custom d-flex align-items-center gap-2",
                                                                        children: [
                                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                                                className: "badge bg-primary text-white rounded-circle d-flex align-items-center justify-content-center",
                                                                                style: {
                                                                                    width: '24px',
                                                                                    height: '24px',
                                                                                    fontSize: '0.75rem'
                                                                                },
                                                                                children: groupIndex + 1
                                                                            }, void 0, false, {
                                                                                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                lineNumber: 369,
                                                                                columnNumber: 35
                                                                            }, this),
                                                                            "Addon Group"
                                                                        ]
                                                                    }, void 0, true, {
                                                                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                        lineNumber: 368,
                                                                        columnNumber: 33
                                                                    }, this),
                                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                                                        type: "button",
                                                                        onClick: ()=>removeAddonGroup(groupIndex),
                                                                        className: "btn btn-sm btn-outline-danger d-flex align-items-center gap-1 border-0 fw-bold",
                                                                        style: {
                                                                            fontSize: '0.8rem'
                                                                        },
                                                                        children: [
                                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$trash$2d$2$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Trash2$3e$__["Trash2"], {
                                                                                size: 16
                                                                            }, void 0, false, {
                                                                                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                lineNumber: 373,
                                                                                columnNumber: 35
                                                                            }, this),
                                                                            " Delete Group"
                                                                        ]
                                                                    }, void 0, true, {
                                                                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                        lineNumber: 372,
                                                                        columnNumber: 33
                                                                    }, this)
                                                                ]
                                                            }, void 0, true, {
                                                                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                lineNumber: 367,
                                                                columnNumber: 29
                                                            }, this),
                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                className: "row g-3 mb-4",
                                                                children: [
                                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                        className: "col-12 col-md-6",
                                                                        children: [
                                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("label", {
                                                                                className: "form-label small fw-bold text-muted-custom",
                                                                                children: "Group Title (English)"
                                                                            }, void 0, false, {
                                                                                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                lineNumber: 380,
                                                                                columnNumber: 37
                                                                            }, this),
                                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("input", {
                                                                                placeholder: "e.g. Size, Toppings",
                                                                                value: group.title_en,
                                                                                onChange: (e)=>updateAddonGroup(groupIndex, 'title_en', e.target.value),
                                                                                className: "form-control",
                                                                                style: {
                                                                                    backgroundColor: 'var(--hover-bg)',
                                                                                    borderColor: 'var(--border-color)',
                                                                                    color: 'var(--text-color)'
                                                                                }
                                                                            }, void 0, false, {
                                                                                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                lineNumber: 381,
                                                                                columnNumber: 37
                                                                            }, this)
                                                                        ]
                                                                    }, void 0, true, {
                                                                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                        lineNumber: 379,
                                                                        columnNumber: 33
                                                                    }, this),
                                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                        className: "col-12 col-md-6",
                                                                        children: [
                                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("label", {
                                                                                className: "form-label small fw-bold text-muted-custom",
                                                                                children: "Group Title (Arabic)"
                                                                            }, void 0, false, {
                                                                                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                lineNumber: 384,
                                                                                columnNumber: 37
                                                                            }, this),
                                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("input", {
                                                                                placeholder: "عنوان المجموعة",
                                                                                value: group.title_ar,
                                                                                onChange: (e)=>updateAddonGroup(groupIndex, 'title_ar', e.target.value),
                                                                                className: "form-control",
                                                                                style: {
                                                                                    backgroundColor: 'var(--hover-bg)',
                                                                                    borderColor: 'var(--border-color)',
                                                                                    color: 'var(--text-color)'
                                                                                }
                                                                            }, void 0, false, {
                                                                                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                lineNumber: 385,
                                                                                columnNumber: 37
                                                                            }, this)
                                                                        ]
                                                                    }, void 0, true, {
                                                                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                        lineNumber: 383,
                                                                        columnNumber: 33
                                                                    }, this),
                                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                        className: "col-6 col-md-3",
                                                                        children: [
                                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("label", {
                                                                                className: "form-label small fw-bold text-muted-custom",
                                                                                children: "Min Choices"
                                                                            }, void 0, false, {
                                                                                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                lineNumber: 388,
                                                                                columnNumber: 37
                                                                            }, this),
                                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("input", {
                                                                                type: "number",
                                                                                min: "0",
                                                                                value: group.min_choices,
                                                                                onChange: (e)=>updateAddonGroup(groupIndex, 'min_choices', e.target.value),
                                                                                className: "form-control",
                                                                                style: {
                                                                                    backgroundColor: 'var(--hover-bg)',
                                                                                    borderColor: 'var(--border-color)',
                                                                                    color: 'var(--text-color)'
                                                                                }
                                                                            }, void 0, false, {
                                                                                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                lineNumber: 389,
                                                                                columnNumber: 37
                                                                            }, this)
                                                                        ]
                                                                    }, void 0, true, {
                                                                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                        lineNumber: 387,
                                                                        columnNumber: 33
                                                                    }, this),
                                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                        className: "col-6 col-md-3",
                                                                        children: [
                                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("label", {
                                                                                className: "form-label small fw-bold text-muted-custom",
                                                                                children: "Max Choices"
                                                                            }, void 0, false, {
                                                                                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                lineNumber: 392,
                                                                                columnNumber: 37
                                                                            }, this),
                                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("input", {
                                                                                type: "number",
                                                                                min: "1",
                                                                                value: group.max_choices,
                                                                                onChange: (e)=>updateAddonGroup(groupIndex, 'max_choices', e.target.value),
                                                                                className: "form-control",
                                                                                style: {
                                                                                    backgroundColor: 'var(--hover-bg)',
                                                                                    borderColor: 'var(--border-color)',
                                                                                    color: 'var(--text-color)'
                                                                                }
                                                                            }, void 0, false, {
                                                                                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                lineNumber: 393,
                                                                                columnNumber: 37
                                                                            }, this)
                                                                        ]
                                                                    }, void 0, true, {
                                                                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                        lineNumber: 391,
                                                                        columnNumber: 33
                                                                    }, this)
                                                                ]
                                                            }, void 0, true, {
                                                                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                lineNumber: 378,
                                                                columnNumber: 29
                                                            }, this),
                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                className: "bg-light rounded-3 p-3 border",
                                                                style: {
                                                                    backgroundColor: 'var(--hover-bg)',
                                                                    borderColor: 'var(--border-color)'
                                                                },
                                                                children: [
                                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                        className: "d-flex justify-content-between align-items-center mb-3",
                                                                        children: [
                                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                                                className: "small fw-bold",
                                                                                style: {
                                                                                    color: 'var(--text-color)'
                                                                                },
                                                                                children: "Choices / Options"
                                                                            }, void 0, false, {
                                                                                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                lineNumber: 400,
                                                                                columnNumber: 38
                                                                            }, this),
                                                                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                                                                type: "button",
                                                                                onClick: ()=>addChoice(groupIndex),
                                                                                className: "btn btn-sm btn-info text-white fw-bold d-flex align-items-center gap-1 shadow-sm",
                                                                                style: {
                                                                                    fontSize: '0.8rem'
                                                                                },
                                                                                children: [
                                                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$plus$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Plus$3e$__["Plus"], {
                                                                                        size: 14
                                                                                    }, void 0, false, {
                                                                                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                        lineNumber: 402,
                                                                                        columnNumber: 40
                                                                                    }, this),
                                                                                    " Add Choice"
                                                                                ]
                                                                            }, void 0, true, {
                                                                                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                lineNumber: 401,
                                                                                columnNumber: 38
                                                                            }, this)
                                                                        ]
                                                                    }, void 0, true, {
                                                                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                        lineNumber: 399,
                                                                        columnNumber: 33
                                                                    }, this),
                                                                    group.choices.length === 0 ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                        className: "text-center py-3 text-muted small border rounded-2 border-dashed bg-white opacity-75",
                                                                        children: 'No choices added yet. Click "Add Choice" to start.'
                                                                    }, void 0, false, {
                                                                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                        lineNumber: 407,
                                                                        columnNumber: 35
                                                                    }, this) : /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                        className: "d-flex flex-column gap-2",
                                                                        children: group.choices.map((choice, choiceIndex)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                                className: "row g-2 align-items-center bg-white p-2 rounded-2 border shadow-sm",
                                                                                children: [
                                                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                                        className: "col-12 col-md-4",
                                                                                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("input", {
                                                                                            placeholder: "Choice (EN)",
                                                                                            value: choice.title_en,
                                                                                            onChange: (e)=>updateChoice(groupIndex, choiceIndex, 'title_en', e.target.value),
                                                                                            className: "form-control form-control-sm border-0 bg-light"
                                                                                        }, void 0, false, {
                                                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                            lineNumber: 415,
                                                                                            columnNumber: 47
                                                                                        }, this)
                                                                                    }, void 0, false, {
                                                                                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                        lineNumber: 414,
                                                                                        columnNumber: 44
                                                                                    }, this),
                                                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                                        className: "col-12 col-md-4",
                                                                                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("input", {
                                                                                            placeholder: "Choice (AR)",
                                                                                            value: choice.title_ar,
                                                                                            onChange: (e)=>updateChoice(groupIndex, choiceIndex, 'title_ar', e.target.value),
                                                                                            className: "form-control form-control-sm border-0 bg-light"
                                                                                        }, void 0, false, {
                                                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                            lineNumber: 418,
                                                                                            columnNumber: 47
                                                                                        }, this)
                                                                                    }, void 0, false, {
                                                                                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                        lineNumber: 417,
                                                                                        columnNumber: 44
                                                                                    }, this),
                                                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                                        className: "col-8 col-md-3",
                                                                                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                                            className: "input-group input-group-sm",
                                                                                            children: [
                                                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                                                                    className: "input-group-text border-0 bg-light text-muted",
                                                                                                    children: "$"
                                                                                                }, void 0, false, {
                                                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                                    lineNumber: 422,
                                                                                                    columnNumber: 49
                                                                                                }, this),
                                                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("input", {
                                                                                                    type: "number",
                                                                                                    placeholder: "0.00",
                                                                                                    value: choice.price,
                                                                                                    onChange: (e)=>updateChoice(groupIndex, choiceIndex, 'price', e.target.value),
                                                                                                    className: "form-control border-0 bg-light"
                                                                                                }, void 0, false, {
                                                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                                    lineNumber: 423,
                                                                                                    columnNumber: 49
                                                                                                }, this)
                                                                                            ]
                                                                                        }, void 0, true, {
                                                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                            lineNumber: 421,
                                                                                            columnNumber: 47
                                                                                        }, this)
                                                                                    }, void 0, false, {
                                                                                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                        lineNumber: 420,
                                                                                        columnNumber: 45
                                                                                    }, this),
                                                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                                        className: "col-4 col-md-1 text-end",
                                                                                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                                                                            type: "button",
                                                                                            onClick: ()=>removeChoice(groupIndex, choiceIndex),
                                                                                            className: "btn btn-sm text-danger hover-bg-light rounded-circle p-1",
                                                                                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$trash$2d$2$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Trash2$3e$__["Trash2"], {
                                                                                                size: 16
                                                                                            }, void 0, false, {
                                                                                                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                                lineNumber: 428,
                                                                                                columnNumber: 50
                                                                                            }, this)
                                                                                        }, void 0, false, {
                                                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                            lineNumber: 427,
                                                                                            columnNumber: 48
                                                                                        }, this)
                                                                                    }, void 0, false, {
                                                                                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                        lineNumber: 426,
                                                                                        columnNumber: 44
                                                                                    }, this)
                                                                                ]
                                                                            }, choiceIndex, true, {
                                                                                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                lineNumber: 413,
                                                                                columnNumber: 39
                                                                            }, this))
                                                                    }, void 0, false, {
                                                                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                        lineNumber: 411,
                                                                        columnNumber: 35
                                                                    }, this)
                                                                ]
                                                            }, void 0, true, {
                                                                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                lineNumber: 398,
                                                                columnNumber: 29
                                                            }, this)
                                                        ]
                                                    }, groupIndex, true, {
                                                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                        lineNumber: 366,
                                                        columnNumber: 25
                                                    }, this))
                                            ]
                                        }, void 0, true, {
                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                            lineNumber: 346,
                                            columnNumber: 17
                                        }, this),
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "card-custom p-3",
                                            children: [
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                    className: "d-flex justify-content-between align-items-center mb-3",
                                                    children: [
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h5", {
                                                            className: "fw-bold mb-0 d-flex align-items-center gap-2",
                                                            style: {
                                                                color: 'var(--text-color)'
                                                            },
                                                            children: [
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$ellipsis$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__MoreHorizontal$3e$__["MoreHorizontal"], {
                                                                    size: 20,
                                                                    className: "text-primary-custom"
                                                                }, void 0, false, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 444,
                                                                    columnNumber: 25
                                                                }, this),
                                                                "Meta Fields (Advanced)"
                                                            ]
                                                        }, void 0, true, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 443,
                                                            columnNumber: 22
                                                        }, this),
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                                            type: "button",
                                                            onClick: addMetaField,
                                                            className: "btn btn-sm btn-outline-primary fw-bold",
                                                            style: {
                                                                borderColor: 'var(--border-color)',
                                                                color: 'var(--text-color)'
                                                            },
                                                            children: [
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$plus$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Plus$3e$__["Plus"], {
                                                                    size: 16
                                                                }, void 0, false, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 448,
                                                                    columnNumber: 25
                                                                }, this),
                                                                " Add Meta"
                                                            ]
                                                        }, void 0, true, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 447,
                                                            columnNumber: 22
                                                        }, this)
                                                    ]
                                                }, void 0, true, {
                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                    lineNumber: 442,
                                                    columnNumber: 20
                                                }, this),
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                    className: "d-flex flex-column gap-2",
                                                    children: metaFields.map((field, index)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                            className: "row g-2 align-items-center",
                                                            children: [
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                    className: "col-5",
                                                                    children: [
                                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("label", {
                                                                            className: "small fw-bold text-muted-custom mb-1",
                                                                            children: "Key"
                                                                        }, void 0, false, {
                                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                            lineNumber: 456,
                                                                            columnNumber: 33
                                                                        }, this),
                                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("input", {
                                                                            type: "text",
                                                                            className: "form-control form-control-sm",
                                                                            value: field.key,
                                                                            onChange: (e)=>handleMetaChange(index, 'key', e.target.value),
                                                                            style: {
                                                                                backgroundColor: 'var(--bg-color)',
                                                                                color: 'var(--text-color)',
                                                                                borderColor: 'var(--border-color)'
                                                                            }
                                                                        }, void 0, false, {
                                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                            lineNumber: 457,
                                                                            columnNumber: 33
                                                                        }, this)
                                                                    ]
                                                                }, void 0, true, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 455,
                                                                    columnNumber: 29
                                                                }, this),
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                    className: "col-6",
                                                                    children: [
                                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("label", {
                                                                            className: "small fw-bold text-muted-custom mb-1",
                                                                            children: "Value"
                                                                        }, void 0, false, {
                                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                            lineNumber: 460,
                                                                            columnNumber: 33
                                                                        }, this),
                                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("input", {
                                                                            type: "text",
                                                                            className: "form-control form-control-sm",
                                                                            value: field.value,
                                                                            onChange: (e)=>handleMetaChange(index, 'value', e.target.value),
                                                                            style: {
                                                                                backgroundColor: 'var(--bg-color)',
                                                                                color: 'var(--text-color)',
                                                                                borderColor: 'var(--border-color)'
                                                                            }
                                                                        }, void 0, false, {
                                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                            lineNumber: 461,
                                                                            columnNumber: 33
                                                                        }, this)
                                                                    ]
                                                                }, void 0, true, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 459,
                                                                    columnNumber: 30
                                                                }, this),
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                    className: "col-1 d-flex align-items-end justify-content-center pb-1",
                                                                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                                                        type: "button",
                                                                        onClick: ()=>removeMetaField(index),
                                                                        className: "btn btn-sm text-danger p-0 border-0",
                                                                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$x$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__X$3e$__["X"], {
                                                                            size: 18
                                                                        }, void 0, false, {
                                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                            lineNumber: 464,
                                                                            columnNumber: 142
                                                                        }, this)
                                                                    }, void 0, false, {
                                                                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                        lineNumber: 464,
                                                                        columnNumber: 33
                                                                    }, this)
                                                                }, void 0, false, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 463,
                                                                    columnNumber: 29
                                                                }, this)
                                                            ]
                                                        }, index, true, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 454,
                                                            columnNumber: 25
                                                        }, this))
                                                }, void 0, false, {
                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                    lineNumber: 452,
                                                    columnNumber: 21
                                                }, this)
                                            ]
                                        }, void 0, true, {
                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                            lineNumber: 441,
                                            columnNumber: 18
                                        }, this)
                                    ]
                                }, void 0, true, {
                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                    lineNumber: 305,
                                    columnNumber: 15
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                    className: "col-12 col-lg-4",
                                    children: [
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "card-custom p-3 mb-3",
                                            children: [
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h5", {
                                                    className: "fw-bold mb-3",
                                                    style: {
                                                        color: 'var(--text-color)'
                                                    },
                                                    children: "Product Image"
                                                }, void 0, false, {
                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                    lineNumber: 478,
                                                    columnNumber: 20
                                                }, this),
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                    className: "d-flex align-items-center justify-content-center p-3 rounded-3 border-2 border-dashed transition-all hover-bg-custom position-relative overflow-hidden",
                                                    style: {
                                                        borderColor: 'var(--border-color)',
                                                        backgroundColor: 'var(--bg-color)',
                                                        cursor: 'pointer',
                                                        minHeight: '220px'
                                                    },
                                                    children: [
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("input", {
                                                            type: "file",
                                                            accept: "image/*",
                                                            onChange: handleImageChange,
                                                            className: "position-absolute w-100 h-100 opacity-0 cursor-pointer",
                                                            style: {
                                                                zIndex: 10
                                                            }
                                                        }, void 0, false, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 481,
                                                            columnNumber: 23
                                                        }, this),
                                                        imagePreview ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                            className: "w-100 h-100 position-absolute top-0 start-0",
                                                            children: [
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("img", {
                                                                    src: imagePreview,
                                                                    alt: "Preview",
                                                                    className: "w-100 h-100 object-fit-cover"
                                                                }, void 0, false, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 484,
                                                                    columnNumber: 31
                                                                }, this),
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                    className: "position-absolute bottom-0 start-0 w-100 p-2 bg-dark bg-opacity-50 text-white text-center small",
                                                                    children: "Click to change"
                                                                }, void 0, false, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 485,
                                                                    columnNumber: 31
                                                                }, this)
                                                            ]
                                                        }, void 0, true, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 483,
                                                            columnNumber: 27
                                                        }, this) : /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                            className: "text-center",
                                                            children: [
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                    className: "mb-3 d-inline-flex p-3 rounded-circle shadow-sm",
                                                                    style: {
                                                                        backgroundColor: 'var(--hover-bg)'
                                                                    },
                                                                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$upload$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Upload$3e$__["Upload"], {
                                                                        size: 24,
                                                                        className: "text-primary-custom"
                                                                    }, void 0, false, {
                                                                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                        lineNumber: 492,
                                                                        columnNumber: 33
                                                                    }, this)
                                                                }, void 0, false, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 491,
                                                                    columnNumber: 29
                                                                }, this),
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                                                    className: "small fw-bold mb-1",
                                                                    style: {
                                                                        color: 'var(--text-color)'
                                                                    },
                                                                    children: "Drop image here"
                                                                }, void 0, false, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 494,
                                                                    columnNumber: 29
                                                                }, this),
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("p", {
                                                                    className: "small text-muted-custom mb-0",
                                                                    children: "or click to upload"
                                                                }, void 0, false, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 495,
                                                                    columnNumber: 29
                                                                }, this)
                                                            ]
                                                        }, void 0, true, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 490,
                                                            columnNumber: 25
                                                        }, this)
                                                    ]
                                                }, void 0, true, {
                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                    lineNumber: 479,
                                                    columnNumber: 20
                                                }, this)
                                            ]
                                        }, void 0, true, {
                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                            lineNumber: 477,
                                            columnNumber: 18
                                        }, this),
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "card-custom p-3 mb-3",
                                            children: [
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h5", {
                                                    className: "fw-bold mb-3 d-flex align-items-center gap-2",
                                                    style: {
                                                        color: 'var(--text-color)'
                                                    },
                                                    children: [
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$shopping$2d$bag$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__ShoppingBag$3e$__["ShoppingBag"], {
                                                            size: 20,
                                                            className: "text-primary-custom"
                                                        }, void 0, false, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 504,
                                                            columnNumber: 26
                                                        }, this),
                                                        "Organization"
                                                    ]
                                                }, void 0, true, {
                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                    lineNumber: 503,
                                                    columnNumber: 21
                                                }, this),
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                    className: "mb-3",
                                                    children: [
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("label", {
                                                            className: "form-label small fw-bold text-muted-custom",
                                                            children: "Vendor"
                                                        }, void 0, false, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 509,
                                                            columnNumber: 25
                                                        }, this),
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("select", {
                                                            name: "vendor_id",
                                                            value: formData.vendor_id,
                                                            onChange: handleChange,
                                                            className: "form-select",
                                                            required: true,
                                                            style: {
                                                                backgroundColor: 'var(--bg-color)',
                                                                color: 'var(--text-color)',
                                                                borderColor: 'var(--border-color)'
                                                            },
                                                            children: [
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("option", {
                                                                    value: "",
                                                                    children: "Select Vendor..."
                                                                }, void 0, false, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 511,
                                                                    columnNumber: 29
                                                                }, this),
                                                                vendors.map((v)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("option", {
                                                                        value: v.id,
                                                                        children: v.name
                                                                    }, v.id, false, {
                                                                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                        lineNumber: 512,
                                                                        columnNumber: 47
                                                                    }, this))
                                                            ]
                                                        }, void 0, true, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 510,
                                                            columnNumber: 25
                                                        }, this)
                                                    ]
                                                }, void 0, true, {
                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                    lineNumber: 508,
                                                    columnNumber: 21
                                                }, this),
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                    className: "mb-4",
                                                    children: [
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("label", {
                                                            className: "form-label small fw-bold text-muted-custom",
                                                            children: "Categories"
                                                        }, void 0, false, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 517,
                                                            columnNumber: 25
                                                        }, this),
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("select", {
                                                            name: "categories",
                                                            multiple: true,
                                                            value: formData.categories,
                                                            onChange: handleCategoryChange,
                                                            className: "form-select",
                                                            required: true,
                                                            style: {
                                                                backgroundColor: 'var(--bg-color)',
                                                                color: 'var(--text-color)',
                                                                borderColor: 'var(--border-color)',
                                                                height: '120px'
                                                            },
                                                            children: categories.map((c)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("option", {
                                                                    value: c.id,
                                                                    children: c.title
                                                                }, c.id, false, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 519,
                                                                    columnNumber: 50
                                                                }, this))
                                                        }, void 0, false, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 518,
                                                            columnNumber: 25
                                                        }, this),
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("small", {
                                                            className: "text-muted d-block mt-1",
                                                            style: {
                                                                fontSize: '0.7rem'
                                                            },
                                                            children: "Hold Ctrl/Cmd to select multiple"
                                                        }, void 0, false, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 521,
                                                            columnNumber: 25
                                                        }, this)
                                                    ]
                                                }, void 0, true, {
                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                    lineNumber: 516,
                                                    columnNumber: 21
                                                }, this),
                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                    className: "border-top pt-3 mt-3",
                                                    children: [
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("h6", {
                                                            className: "small fw-bold text-muted mb-3",
                                                            children: "Pricing & Inventory"
                                                        }, void 0, false, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 525,
                                                            columnNumber: 26
                                                        }, this),
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                            className: "mb-3",
                                                            children: [
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("label", {
                                                                    className: "form-label small fw-bold text-muted-custom",
                                                                    children: "Price"
                                                                }, void 0, false, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 527,
                                                                    columnNumber: 29
                                                                }, this),
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                    className: "input-group",
                                                                    children: [
                                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                                            className: "input-group-text",
                                                                            style: {
                                                                                backgroundColor: 'var(--bg-color)',
                                                                                borderColor: 'var(--border-color)',
                                                                                color: 'var(--text-color)'
                                                                            },
                                                                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$dollar$2d$sign$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__DollarSign$3e$__["DollarSign"], {
                                                                                size: 16
                                                                            }, void 0, false, {
                                                                                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                lineNumber: 529,
                                                                                columnNumber: 180
                                                                            }, this)
                                                                        }, void 0, false, {
                                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                            lineNumber: 529,
                                                                            columnNumber: 34
                                                                        }, this),
                                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("input", {
                                                                            type: "number",
                                                                            name: "price",
                                                                            value: formData.price,
                                                                            onChange: handleChange,
                                                                            className: "form-control",
                                                                            placeholder: "0.00",
                                                                            required: true,
                                                                            style: {
                                                                                backgroundColor: 'var(--bg-color)',
                                                                                color: 'var(--text-color)',
                                                                                borderColor: 'var(--border-color)'
                                                                            }
                                                                        }, void 0, false, {
                                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                            lineNumber: 530,
                                                                            columnNumber: 33
                                                                        }, this)
                                                                    ]
                                                                }, void 0, true, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 528,
                                                                    columnNumber: 29
                                                                }, this)
                                                            ]
                                                        }, void 0, true, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 526,
                                                            columnNumber: 26
                                                        }, this),
                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                            className: "mb-0",
                                                            children: [
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("label", {
                                                                    className: "form-label small fw-bold text-muted-custom",
                                                                    children: "Stock Quantity"
                                                                }, void 0, false, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 535,
                                                                    columnNumber: 29
                                                                }, this),
                                                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                                    className: "input-group",
                                                                    children: [
                                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                                                                            className: "input-group-text",
                                                                            style: {
                                                                                backgroundColor: 'var(--bg-color)',
                                                                                borderColor: 'var(--border-color)',
                                                                                color: 'var(--text-color)'
                                                                            },
                                                                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$archive$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Archive$3e$__["Archive"], {
                                                                                size: 16
                                                                            }, void 0, false, {
                                                                                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                                lineNumber: 537,
                                                                                columnNumber: 180
                                                                            }, this)
                                                                        }, void 0, false, {
                                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                            lineNumber: 537,
                                                                            columnNumber: 34
                                                                        }, this),
                                                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("input", {
                                                                            type: "number",
                                                                            name: "stock_quantity",
                                                                            value: formData.stock_quantity,
                                                                            onChange: handleChange,
                                                                            className: "form-control",
                                                                            placeholder: "0",
                                                                            required: true,
                                                                            style: {
                                                                                backgroundColor: 'var(--bg-color)',
                                                                                color: 'var(--text-color)',
                                                                                borderColor: 'var(--border-color)'
                                                                            }
                                                                        }, void 0, false, {
                                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                            lineNumber: 538,
                                                                            columnNumber: 33
                                                                        }, this)
                                                                    ]
                                                                }, void 0, true, {
                                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                                    lineNumber: 536,
                                                                    columnNumber: 30
                                                                }, this)
                                                            ]
                                                        }, void 0, true, {
                                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                            lineNumber: 534,
                                                            columnNumber: 25
                                                        }, this)
                                                    ]
                                                }, void 0, true, {
                                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                    lineNumber: 524,
                                                    columnNumber: 21
                                                }, this)
                                            ]
                                        }, void 0, true, {
                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                            lineNumber: 502,
                                            columnNumber: 18
                                        }, this),
                                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                            className: "col-12",
                                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                                className: "d-flex gap-2",
                                                children: [
                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                                        type: "submit",
                                                        disabled: loading,
                                                        className: "btn btn-success fw-bold  shadow-sm py-2",
                                                        style: {
                                                            background: 'linear-gradient(135deg, rgb(249, 115, 22) 0%, rgb(234, 88, 12) 100%)',
                                                            border: 'none'
                                                        },
                                                        children: loading ? "UPDATING..." : "UPDATE PRODUCT"
                                                    }, void 0, false, {
                                                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                        lineNumber: 547,
                                                        columnNumber: 24
                                                    }, this),
                                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                                                        href: "/admin/products",
                                                        className: "btn btn-light fw-bold px-3 border",
                                                        style: {
                                                            color: 'var(--text-color)'
                                                        },
                                                        children: "Cancel"
                                                    }, void 0, false, {
                                                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                        lineNumber: 550,
                                                        columnNumber: 24
                                                    }, this)
                                                ]
                                            }, void 0, true, {
                                                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                                lineNumber: 546,
                                                columnNumber: 20
                                            }, this)
                                        }, void 0, false, {
                                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                            lineNumber: 545,
                                            columnNumber: 17
                                        }, this)
                                    ]
                                }, void 0, true, {
                                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                                    lineNumber: 474,
                                    columnNumber: 15
                                }, this)
                            ]
                        }, void 0, true, {
                            fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                            lineNumber: 302,
                            columnNumber: 13
                        }, this)
                    }, void 0, false, {
                        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                        lineNumber: 301,
                        columnNumber: 11
                    }, this)
                }, void 0, false, {
                    fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                    lineNumber: 300,
                    columnNumber: 9
                }, this)
            }, void 0, false, {
                fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
                lineNumber: 299,
                columnNumber: 7
            }, this)
        ]
    }, void 0, true, {
        fileName: "[project]/frontend/src/app/admin/products/[id]/edit/page.tsx",
        lineNumber: 296,
        columnNumber: 5
    }, this);
}
_s(EditProductPage, "5x3Dyi/4VAoZMBwcS8+a42z/ogU=", false, function() {
    return [
        __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRouter"],
        __TURBOPACK__imported__module__$5b$project$5d2f$frontend$2f$node_modules$2f$next$2f$navigation$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useParams"]
    ];
});
_c = EditProductPage;
var _c;
__turbopack_context__.k.register(_c, "EditProductPage");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
]);

//# sourceMappingURL=frontend_src_5b0b1953._.js.map